/**  @file bta_crop_chessboard.h
*
*    @brief This file implements the DCT computation
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_CROP_CHESSBOARD_H_INCLUDED
#define BTA_CROP_CHESSBOARD_H_INCLUDED


typedef struct BTA_FltCropChessboardInst {
    BTA_ChannelId channelToProcess;
    float scaleFactor;
    uint8_t edgeCountHor;
    uint8_t edgeCountVert;
    float border;
    BTA_ChannelId channelIdResult;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltCropChessboardInst;


BTA_Status BFLTcropChessboardInit(BTA_FltCropChessboardConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTcropChessboardClose(BTA_FltHandle *handle);
BTA_Status BFLTcropChessboardApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif